/*var synoLargeFileData = [
	[ 'public', '/volume1/public/aa', 1024 ],
	[ 'music',  '/volume1/music/bb',  2048 ],
	[ 'video',  '/volume1/video/vv',  4096 ]
];*/

function LargeFile()
{
    Ext.QuickTips.init();

	if(typeof synoLargeFileData === 'undefined' || synoLargeFileData.length === 0) {
        NoDataSet('large_file_nodata');
        return ;
    }


    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.    
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

	var store = new Ext.data.ArrayStore({
		fields: [
			{name: 'Share'},
			{name: 'File'},
			{name: 'Size', type: 'int'}
		]
	});

	// manually load local data
	store.loadData(synoLargeFileData);

    // create the Grid
    var grid = new Ext.grid.GridPanel({
		border: false,
		store: store,
		stripeRows: true,
        width: 930,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		view: new Ext.ux.grid.BufferView(BufferViewConfig),
		columns: [{
			header   : _T('report','reportUI_title_share'),
			width    : 180,
			sortable : true,
			dataIndex: 'Share',
			tooltip  : _T('report','reportUI_title_share'),
			css: 'font-weight: bold;'
		},
		{
			header   : _T('common', 'file'),
			width    : 620,
			sortable : true,
			dataIndex: 'File',
			tooltip  : _T('common', 'file'),
			renderer: htmlEncodeRenderer
		},
		{
			header   : _T('common', 'size'),
			width    : 130,
			sortable : true,
			tooltip  : _T('common', 'size'),
			renderer : SizeUnit,
			dataIndex: 'Size'
		}],
		plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()]
	});

	// render the grid to the specified div in the page
	grid.render('large_file');
}
